/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public abstract class LookAndFeel {
    public void initialize() {
    }

    public void uninitialize() {
    }

    public boolean getSupportsWindowDecorations() {
        return false;
    }

    public abstract boolean isNativeLookAndFeel();

    public abstract boolean isSupportedLookAndFeel();

    public void provideErrorFeedback(Component component) {
        Toolkit toolkit = null;
        toolkit = component != null ? component.getToolkit() : Toolkit.getDefaultToolkit();
        toolkit.beep();
    }

    public abstract String getDescription();

    public abstract String getID();

    public abstract String getName();

    public String toString() {
        return "[" + this.getDescription() + " - " + this.getClass().getName() + "]";
    }

    public static void uninstallBorder(JComponent jComponent) {
        if (jComponent.getBorder() instanceof UIResource) {
            jComponent.setBorder(null);
        }
    }

    public UIDefaults getDefaults() {
        return null;
    }

    public static void loadKeyBindings(InputMap inputMap, Object[] objectArray) {
        if (objectArray != null) {
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object;
                KeyStroke keyStroke = (object = objectArray[i2++]) instanceof KeyStroke ? (KeyStroke)object : KeyStroke.getKeyStroke((String)object);
                inputMap.put(keyStroke, objectArray[i2]);
            }
        }
    }

    public static void installBorder(JComponent jComponent, String string) {
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            jComponent.setBorder(UIManager.getBorder(string));
        }
    }

    public static InputMap makeInputMap(Object[] objectArray) {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        LookAndFeel.loadKeyBindings(inputMapUIResource, objectArray);
        return inputMapUIResource;
    }

    public static JTextComponent.KeyBinding[] makeKeyBindings(Object[] objectArray) {
        JTextComponent.KeyBinding[] keyBindingArray = new JTextComponent.KeyBinding[objectArray.length / 2];
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            KeyStroke keyStroke = objectArray[i2] instanceof KeyStroke ? (KeyStroke)objectArray[i2] : KeyStroke.getKeyStroke((String)objectArray[i2]);
            String string = (String)objectArray[i2 + 1];
            keyBindingArray[i2 / 2] = new JTextComponent.KeyBinding(keyStroke, string);
        }
        return keyBindingArray;
    }

    public static Object getDesktopPropertyValue(String string, Object object) {
        Object object2 = Toolkit.getDefaultToolkit().getDesktopProperty(string);
        if (object2 == null) {
            return object;
        }
        if (object2 instanceof Color) {
            return new ColorUIResource((Color)object2);
        }
        if (object2 instanceof Font) {
            return new FontUIResource((Font)object2);
        }
        return object2;
    }

    public static Object makeIcon(Class clazz, String string) {
        return new UIDefaults.LazyValue(clazz, string){
            private final Class val$baseClass;
            private final String val$gifFile;

            static Class access$100(1 var0) {
                return var0.val$baseClass;
            }

            public Object createValue(UIDefaults uIDefaults) {
                byte[][] byArrayArray = new byte[1][];
                SwingUtilities.doPrivileged(new Runnable(this, byArrayArray){
                    private final byte[][] val$buffer;
                    private final 1 this$0;

                    public void run() {
                        try {
                            int n2;
                            InputStream inputStream = 1.access$100(this.this$0).getResourceAsStream(1.access$000(this.this$0));
                            if (inputStream == null) {
                                return;
                            }
                            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                            this.val$buffer[0] = new byte[1024];
                            while ((n2 = bufferedInputStream.read(this.val$buffer[0])) > 0) {
                                byteArrayOutputStream.write(this.val$buffer[0], 0, n2);
                            }
                            bufferedInputStream.close();
                            byteArrayOutputStream.flush();
                            this.val$buffer[0] = byteArrayOutputStream.toByteArray();
                        }
                        catch (IOException iOException) {
                            System.err.println(iOException.toString());
                            return;
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.val$buffer = byArray;
                    }
                });
                if (byArrayArray[0] == null) {
                    System.err.println(this.val$baseClass.getName() + "/" + this.val$gifFile + " not found.");
                    return null;
                }
                if (byArrayArray[0].length == 0) {
                    System.err.println("warning: " + this.val$gifFile + " is zero-length");
                    return null;
                }
                return new IconUIResource(new ImageIcon(byArrayArray[0]));
            }
            {
                this.val$baseClass = clazz;
                this.val$gifFile = string;
            }

            static String access$000(1 var0) {
                return var0.val$gifFile;
            }
        };
    }

    public static void installColors(JComponent jComponent, String string, String string2) {
        Color color;
        Color color2 = jComponent.getBackground();
        if (color2 == null || color2 instanceof UIResource) {
            jComponent.setBackground(UIManager.getColor(string));
        }
        if ((color = jComponent.getForeground()) == null || color instanceof UIResource) {
            jComponent.setForeground(UIManager.getColor(string2));
        }
    }

    public static ComponentInputMap makeComponentInputMap(JComponent jComponent, Object[] objectArray) {
        ComponentInputMapUIResource componentInputMapUIResource = new ComponentInputMapUIResource(jComponent);
        LookAndFeel.loadKeyBindings(componentInputMapUIResource, objectArray);
        return componentInputMapUIResource;
    }

    public static void installColorsAndFont(JComponent jComponent, String string, String string2, String string3) {
        Font font = jComponent.getFont();
        if (font == null || font instanceof UIResource) {
            jComponent.setFont(UIManager.getFont(string3));
        }
        LookAndFeel.installColors(jComponent, string, string2);
    }
}

